/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LabelGunResetRecipe
extends CustomRecipe {
    public LabelGunResetRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        int foundLabelGuns = 0;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (stack.getItem() instanceof LabelGunItem) {
                ++foundLabelGuns;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return foundLabelGuns > 0;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        int foundLabelGuns = 0;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (stack.getItem() instanceof LabelGunItem) {
                ++foundLabelGuns;
                continue;
            }
            if (stack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return foundLabelGuns > 0 ? new ItemStack((ItemLike)SFMItems.LABEL_GUN_ITEM.get(), foundLabelGuns) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SFMRecipeSerializers.LABEL_GUN_RESET.get();
    }
}

